package furny.util;

import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.apache.log4j.xml.DOMConfigurator;
import org.slf4j.bridge.SLF4JBridgeHandler;

import de.lessvoid.nifty.Nifty;
import furny.Furny;

/**
 * Utility class for handling loggers.
 * 
 * @since 11.08.2012
 * @author Stephan Dreyer
 */
public final class LoggerUtil {

  // the logger for this class
  private static final Logger LOGGER = Logger.getLogger(LoggerUtil.class
      .getName());

  private static boolean loggerInstalled;

  /**
   * Instantiation is not allowed.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  private LoggerUtil() {
  }

  /**
   * Installs the logger.
   * 
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public static void installLogger() {
    if (!loggerInstalled) {
      loggerInstalled = true;

      DOMConfigurator.configure(Furny.class.getClassLoader().getResource(
          "furny/logger/log4j.xml"));

      Logger.getLogger("de.lessvoid").setLevel(Level.WARNING);
      Logger.getLogger(Nifty.class.getName()).setLevel(Level.WARNING);
      Logger.getLogger("NiftyEventBusLog").setLevel(Level.WARNING);

      SLF4JBridgeHandler.install();

      LOGGER.info("Logger installed");
    } else {
      LOGGER.info("Logger is already installed");
    }
  }

  /**
   * Mutes the logger. It will only show warnings.
   * 
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public static void muteRootLogger() {
    final Logger julLogger = Logger.getLogger("");
    for (final Handler h : julLogger.getHandlers()) {
      if (h instanceof ConsoleHandler) {
        ((ConsoleHandler) h).setLevel(Level.WARNING);
      }
    }
  }

}
